# Version 5.5.7 - Withdrawal System Fixes

**Release Date:** October 21, 2025

## Critical Fixes

### Withdrawal Balance Calculation
- **Fixed NATIVE EVM token withdrawal fee calculation** - Gas fees are now correctly paid FROM the withdrawal amount instead of being added on top
  - Affected chains: ETH, BSC, POLYGON, FTM, OPTIMISM, ARBITRUM, BASE, CELO, RSK, AVAX
  - Previously: `totalToDeduct = withdrawAmount + platformFee + gasFee` (incorrect)
  - Now: `totalToDeduct = withdrawAmount + platformFee` (gas paid from withdrawal itself)

### Max Withdrawal Calculation
- **Added gas fee estimation for NATIVE EVM tokens in max withdrawal endpoint**
  - Max withdrawal now subtracts estimated gas fee to prevent "Insufficient funds" errors
  - Formula: `maxAmount = availableBalance - platformFee - estimatedGas`

### String Concatenation Bugs
- **Fixed critical string concatenation issues in balance calculations** (7 locations)
  - Database stores balances as strings, causing concatenation instead of addition
  - Example bug: `"0.00689273" + "0.0001"` resulted in `"0.006892730.0001"` instead of `0.00699273`
  - Added `parseFloat()` before all arithmetic operations on wallet balances

### Floating-Point Precision Errors
- **Added EVM chains to balance precision function**
  - Fixed precision errors like `0.000890629999999999` displaying instead of `0.00089063`
  - Added chains: BSC, ETH, POLYGON, ARBITRUM, OPTIMISM, BASE, AVAX, FTM, CELO, RSK (all with 8 decimal precision)

### Gas Fee Reconciliation
- **Implemented gas fee reconciliation for NATIVE EVM withdrawals**
  - Compares estimated vs actual gas used after transaction confirms
  - Refunds difference if overestimated, deducts if underestimated
  - Keeps database balance synchronized with on-chain balance

### Private Ledger Integration
- **Fixed withdrawal balance checks to consider private ledger**
  - For PERMIT tokens, now checks: `availableBalance = wallet_data.balance - offchainDifference`
  - Prevents users from withdrawing admin fees collected in cross-token exchanges
  - Applied in both max withdrawal and withdrawal validation

### Monero (XMR) Deposit Processing
- **Fixed XMR deposit deadlock issue**
  - Created `processMoneroTransactionDirect` method to handle deposits when wallet is already open
  - Prevents "0/120 attempt" stalling on deposits

## Technical Improvements

### Balance Checking Logic
- Changed from checking `wallet.balance` (total across all chains) to `wallet_data.balance` (chain-specific available balance)
- Ensures users can only withdraw what's actually available on the specific blockchain

### Gas Estimation
- Implemented proper gas estimation for NATIVE EVM tokens before withdrawal
- Uses 21000 gas limit for standard transfers
- Fetches current gas price from blockchain
- Falls back to conservative estimates if estimation fails

### Private Ledger Logic
- `offchainDifference` > 0: Admin fees collected (reduces available balance)
- `offchainDifference` < 0: User credited from exchange (increases available balance)
- Only applies to PERMIT contract type tokens