# Ecosystem v5.2.3

**Release Date:** October 9, 2025
**Tags:** BUG FIXES, UTXO, WITHDRAWALS, MONERO, DEPOSITS, BALANCE INTEGRITY

## Fixed

### UTXO Withdrawals (BTC, LTC, DOGE, DASH)
- **Fixed** Balance inconsistency between `wallet` and `wallet_data` tables after failed withdrawals
- **Fixed** UTXO withdrawals failing after balance deduction (now validates before deducting)
- **Fixed** Floating-point precision errors in balance calculations (e.g., `0.000049 + 0.000001` now correctly equals `0.00005`)
- **Fixed** `wallet_data` table not being refunded when withdrawal fails
- **Fixed** Network fee estimation for UTXO chains
- **Fixed** Withdrawal validation happening after balance was already deducted
- **Fixed** Confusing "Network Fee" label (now correctly labeled as "Platform Fee")
- **Fixed** Missing maximum withdrawable amount display for UTXO chains
- **Fixed** "Use Max" button using incorrect balance calculation

### Monero (XMR) Withdrawals
- **Fixed** Balance skew on XMR withdrawals with batch transfers
- **Fixed** Admin profit splitting calculations for XMR withdrawals
- **Fixed** XMR withdrawal processing with proper fee handling

### UTXO Deposits
- **Fixed** UTXO deposit monitoring for BTC, LTC, DOGE, DASH
- **Fixed** Deposit confirmation tracking improvements


## Added

### Withdrawal Maximum Calculation
- **Added** New `/api/ecosystem/withdraw/max` GET endpoint to calculate maximum withdrawable amount
- **Added** Binary search algorithm to find exact maximum withdrawable amount after all fees
- **Added** UTXO pre-validation before balance deduction
- **Added** Real-time maximum withdrawable amount display in withdrawal form
- **Added** Blue info alert showing:
  - Maximum withdrawable amount
  - Platform fee breakdown
  - Estimated network fee (for UTXO chains)
  - Reason if withdrawal is not possible
- **Added** UTXO count information in max withdrawal calculations


## Improved

### UTXO Handling
- **Improved** UTXO selection algorithm with better fee estimation
- **Improved** UTXO validation with detailed error messages
- **Improved** `calculateMinimumWithdrawal` function with accurate network fee calculation
- **Improved** UTXO transaction building process
- **Improved** Change output handling in UTXO transactions

### Withdrawal Flow
- **Improved** Withdrawal validation now happens BEFORE balance deduction (prevents unnecessary refunds)
- **Improved** Precision handling with `.toFixed()` applied consistently across all calculations
- **Improved** `refundUser` function now properly refunds both `wallet` and `wallet_data` tables
- **Improved** Total amount calculation with precision fixes
- **Improved** Error messages for failed withdrawals with detailed reasons

### Withdrawal UX
- **Improved** Withdrawal form now fetches and displays maximum withdrawable amount automatically
- **Improved** "Use Max" button now uses calculated maximum instead of simple balance-fee
- **Improved** Fee display with clear distinction between platform and network fees
- **Improved** Loading states when fetching max withdrawable amount
- **Improved** Error handling for max amount calculation failures

### EVM & Chain Support
- **Improved** EVM deposit monitoring
- **Improved** Chain utility functions
- **Improved** Transaction status tracking

### Monero (XMR)
- **Improved** XMR batch transfer logic
- **Improved** XMR fee calculations
- **Improved** XMR admin profit splitting