class IcoTokenDetailModel {
  const IcoTokenDetailModel({
    required this.id,
    required this.offeringId,
    required this.tokenType,
    required this.totalSupply,
    required this.tokensForSale,
    required this.salePercentage,
    required this.blockchain,
    required this.description,
    required this.useOfFunds,
    required this.links,
  });

  final String id;
  final String offeringId;
  final String tokenType;
  final double totalSupply;
  final double tokensForSale;
  final double salePercentage;
  final String blockchain;
  final String description;
  final Map<String, dynamic> useOfFunds;
  final Map<String, dynamic> links;

  factory IcoTokenDetailModel.fromJson(Map<String, dynamic> json) {
    return IcoTokenDetailModel(
      id: json['id'] as String,
      offeringId: json['offeringId'] as String,
      tokenType: json['tokenType'] as String,
      totalSupply: (json['totalSupply'] as num).toDouble(),
      tokensForSale: (json['tokensForSale'] as num).toDouble(),
      salePercentage: (json['salePercentage'] as num).toDouble(),
      blockchain: json['blockchain'] as String,
      description: json['description'] as String,
      useOfFunds: json['useOfFunds'] as Map<String, dynamic>,
      links: json['links'] as Map<String, dynamic>,
    );
  }

  Map<String, dynamic> toJson() {
    return {
      'id': id,
      'offeringId': offeringId,
      'tokenType': tokenType,
      'totalSupply': totalSupply,
      'tokensForSale': tokensForSale,
      'salePercentage': salePercentage,
      'blockchain': blockchain,
      'description': description,
      'useOfFunds': useOfFunds,
      'links': links,
    };
  }
}
