import 'package:json_annotation/json_annotation.dart';
import '../../domain/entities/staking_stats_entity.dart';

part 'staking_stats_model.g.dart';

/// Data model for staking statistics coming from API
@JsonSerializable()
class StakingStatsModel extends StakingStatsEntity {
  const StakingStatsModel({
    required double totalStaked,
    required int activeUsers,
    required double avgApr,
    required double totalRewards,
  }) : super(
          totalStaked: totalStaked,
          activeUsers: activeUsers,
          avgApr: avgApr,
          totalRewards: totalRewards,
        );

  factory StakingStatsModel.fromJson(Map<String, dynamic> json) =>
      _$StakingStatsModelFromJson(json);

  Map<String, dynamic> toJson() => _$StakingStatsModelToJson(this);
}
